package w83a.w83aOperacionesPaso.w83aResultados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83a.w83aBeans.W83aResultadosBean;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aUtilidades.W83aUtilidadesComunes;
import w83a.w83aUtilidades.W83aUtilidadesExcel;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aDateUtil;
import w83a.w83aUtilidadesComunes.W83aUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83aTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83aTablaCuadroResultadosClasifExcelAction extends Q70ActionPasoOP{
	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83aCuadroResultadosClasif.xls";
		InputStream inputStream = W83aTablaCuadroResultadosClasifExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hasta 49"); // Creacin de la hoja
        
        wb.setSheetName(1,"Ms de 49"); // Creacin de la hoja
        
        Map mapaMenorIgual49 = (HashMap)contexto.get("w83aMapResMenorIgual49Bean");
        Map mapaMayor49 = (HashMap)contexto.get("w83aMapResMayor49Bean");
        Map cab = (HashMap)contexto.get("w83aMapCabeceraResultadosBean");
        W83aResultadosBean resultadoBean = (W83aResultadosBean)contexto.get("w83aResultadosBean");
        
        String idioma = (String)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
     
        Map listaHasta49=new HashMap();
        Map listaMas49=new HashMap();
        
        if (!"0".equals(resultadoBean.getTerritorio())){
    	   listaHasta49=new TreeMap((Map)mapaMenorIgual49.get(resultadoBean.getTerritorio()+"|menos49"));
           listaMas49=new TreeMap((Map)mapaMayor49.get(resultadoBean.getTerritorio()+"|mas49"));
    	   if (listaHasta49.size()>0&&listaMas49.size()==0){
           		wb.removeSheetAt(1);
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramenos49"),(Map)listaHasta49.get("sindicatos"),"menos",0,wb,idioma,"unterrit");
           		crearcontenidoterritorio(wb,0,idioma,(Map)listaHasta49.get("sindicatos"),resultadoBean.getPorcentaje());
    	   }else if(listaHasta49.size()==0&&listaMas49.size()>0){
           		wb.removeSheetAt(0);
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramas49"),(Map)listaMas49.get("sindicatos"),"mas",0,wb,idioma,"unterrit");
           		crearcontenidoterritorio(wb,0,idioma,(Map)listaMas49.get("sindicatos"),resultadoBean.getPorcentaje());
    	   }else{
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramenos49"),(Map)listaHasta49.get("sindicatos"),"menos",0,wb,idioma,"unterrit");
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramas49"),(Map)listaMas49.get("sindicatos"),"mas",1,wb,idioma,"unterrit");
           		crearcontenidoterritorio(wb,0,idioma,(Map)listaHasta49.get("sindicatos"),resultadoBean.getPorcentaje());
            	crearcontenidoterritorio(wb,1,idioma,(Map)listaMas49.get("sindicatos"),resultadoBean.getPorcentaje());
    	   }	
        }else{
        	listaHasta49=new TreeMap((Map)mapaMenorIgual49.get("todos|menos49"));
            listaMas49=new TreeMap((Map)mapaMayor49.get("todos|mas49"));
            if (listaHasta49.size()>0&&listaMas49.size()==0){
           		wb.removeSheetAt(1);
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramenos49"),(Map)listaHasta49.get("sindicatos"),"menos",0,wb,idioma,"territs");
           		crearcontenidotodos(wb,0,idioma,(Map)listaHasta49.get("sindicatos"),resultadoBean.getPorcentaje());
            }else if(listaHasta49.size()==0&&listaMas49.size()>0){
           		wb.removeSheetAt(1);
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramas49"),(Map)listaMas49.get("sindicatos"),"mas",0,wb,idioma,"territs");
           		crearcontenidotodos(wb,0,idioma,(Map)listaMas49.get("sindicatos"),resultadoBean.getPorcentaje());
            }else{
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramenos49"),(Map)listaHasta49.get("sindicatos"),"menos",0,wb,idioma,"territs");
           		crearcabecera(contexto,((W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada(),resultadoBean,(ArrayList)cab.get("cabeceramas49"),(Map)listaMas49.get("sindicatos"),"mas",1,wb,idioma,"territs");
           		crearcontenidotodos(wb,0,idioma,(Map)listaHasta49.get("sindicatos"),resultadoBean.getPorcentaje());
            	crearcontenidotodos(wb,1,idioma,(Map)listaMas49.get("sindicatos"),resultadoBean.getPorcentaje());
            }	
        }
        
        byte[] bytesExcel = W83aUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoCuadroResumenResultados.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	
	private void inicializarCero(HSSFRow row, HSSFCell cell, int num){//NOPMD
		cell = row.createCell((short)num);
    	cell.setCellValue(0);
	}
	
	private void crearcabecera(Q70ContextoEJIE contexto, String domicilio,W83aResultadosBean resultadoBean, List cabecera, Map m, String literal, int s,HSSFWorkbook wb,String idioma, String territ) throws Exception{//NOPMD
		W83aUtilidadesExcel excel = new W83aUtilidadesExcel(wb);
		HSSFSheet sheet = wb.getSheetAt(s);
		W83aUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        ///String provincia = W83aUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        String provincia = usuario.getCodTerritorioDelegacion();       
        
        HSSFRow row;
        HSSFCell cell;
               
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)5);
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme_es",idioma));
                
        cell.setCellValue(tituloImagenEu.toString());
        cell = row.getCell((short)9);
        
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEs = new StringBuffer();
        tituloImagenEu = new StringBuffer();
        
        if(W83aClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_es",idioma));
        }else if(W83aClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }
        else if(W83aClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83aClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)0);
        StringBuffer titulo = new StringBuffer();
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloCuadroResultadosClasif_eu",idioma));
        titulo.append(" ");
        titulo.append("/");
        titulo.append(" ");
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloCuadroResultadosClasif_es",idioma));
        cell.setCellValue(titulo.toString());
        
        
       
        row = sheet.getRow((short)10); 
		cell = row.getCell((short)3); 
		if ("0".equals(resultadoBean.getTerritorio())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.comautvascaentero",idioma)+" - "+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));		
        }
        else{
        	cell.setCellValue(resultadoBean.getDescTerritorio().toUpperCase()+" - "+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
        }
        
        row = sheet.getRow((short)11);
        if(resultadoBean.getPorcentaje()!=null && !"".equals(resultadoBean.getPorcentaje())){
	        cell = row.getCell((short)2); 
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.porcentajeSobreTotal",idioma)+": "+resultadoBean.getPorcentaje()+"%");
	        
        }
        
        cell = row.getCell((short)9); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.clasificarnumtrab",idioma));
        cell = row.createCell((short)12); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.si",idioma));
        
        row = sheet.createRow((short)13); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.datosgenerales",idioma));
        cell = row.createCell((short)8); 
        cell.setCellValue(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(resultadoBean.getFechaRegistroDefinitivo(),idioma), idioma));
        int numempresas=cabecera.size();
        int numcentros=0;
        int numvotos=0;
        int totalelectores=0;
        int hasta49=0;
        int masde49=0;
        for (int i=0;i<cabecera.size();i++){
        	numcentros=numcentros+Integer.parseInt(((W83aResultadosBean)cabecera.get(i)).getNumcentros());
        	numvotos=numvotos+Integer.parseInt(((W83aResultadosBean)cabecera.get(i)).getTotalvotos());
        	totalelectores=totalelectores+Integer.parseInt(((W83aResultadosBean)cabecera.get(i)).getNumTrabajadores());
        }
        
        row = sheet.createRow((short)15); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numempresas",idioma));
        cell = row.createCell((short)3); 
        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        cell.setCellValue(numempresas);
        cell = row.createCell((short)10); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numcentros",idioma));
        cell = row.createCell((short)12); 
        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        cell.setCellValue(numcentros);
        
        row = sheet.createRow((short)16); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalelectores",idioma));
        cell = row.createCell((short)3); 
        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        cell.setCellValue(totalelectores);
        cell = row.createCell((short)5); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalvotantes",idioma));
        cell = row.createCell((short)7); 
        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        cell.setCellValue(numvotos);
        cell = row.createCell((short)10); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.porcentaje",idioma));
        cell = row.createCell((short)12); 
        if (totalelectores!=0){
        	cell.setCellValue(W83aUtilidades.porcentaje(numvotos,totalelectores));//"%"
        }
        else{
        	cell.setCellValue(0);
        }
        cell.setCellStyle(stylePorcentajesDcha(excel));
        row = sheet.createRow((short)18); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numdeleg",idioma));
        Iterator it;
        row = sheet.createRow((short)20);
        if ("unterrit".equals(territ)){
        	if ("menos".equals(literal)){
        		Set ref = m.keySet();
        		 for( it = ref.iterator(); it.hasNext();) {
        			String a=(String)it.next();
                	Map c=(HashMap)m.get(a);
                	if (c!=null){
                		if (c.get("F")!=null){
                			hasta49=hasta49+Integer.parseInt((String)c.get("F"));
                		}
                		if (c.get("L")!=null){
                			hasta49=hasta49+Integer.parseInt((String)c.get("L"));
                		}
                	}
                }
            	
                	cell = row.createCell((short)1); 
                    cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.hasta49",idioma));
                    cell = row.createCell((short)2); 
                    cell.setCellStyle(styleDerechaNumeroFormateado(excel));
                    cell.setCellValue(hasta49);
            }
            if ("mas".equals(literal)){
            	Set ref = m.keySet();
       		 	for( it = ref.iterator(); it.hasNext();) {
       		 		String a=(String)it.next();
       		 		Map c=(HashMap)m.get(a);
                	if (c!=null){
                		if (c.get("F")!=null){
                			masde49=masde49+Integer.parseInt((String)c.get("F"));
                		}
                		if (c.get("L")!=null){
                			masde49=masde49+Integer.parseInt((String)c.get("L"));
                		}
                	}
                }
                	cell = row.createCell((short)4); 
                    cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.demasde49",idioma));
                    cell = row.createCell((short)6); 
                    cell.setCellStyle(styleDerechaNumeroFormateado(excel));
                    cell.setCellValue(masde49);
            } 
        }
        else{
        	if ("menos".equals(literal)){
        		Set ref = m.keySet();
       		 	for( it = ref.iterator(); it.hasNext();) {
       		 		String a=(String)it.next();
       		 		Map c=(HashMap)m.get(a);
                	if (c!=null){
                		if (c.get("F")!=null){
                			Map t=(Map)c.get("F");
                			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
                			}
                		}
                		if (c.get("L")!=null){
                			Map t=(Map)c.get("L");
                			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
                				hasta49=hasta49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
                			}
                		}
                	}
                }
            	
                	cell = row.createCell((short)1); 
                    cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.hasta49",idioma));
                    cell = row.createCell((short)2); 
                    cell.setCellStyle(styleDerechaNumeroFormateado(excel));
                    cell.setCellValue(hasta49);
            }
            if ("mas".equals(literal)){
            	Set ref = m.keySet();
       		 	for( it = ref.iterator(); it.hasNext();) {
       		 		String a=(String)it.next();
       		 		Map c=(HashMap)m.get(a);
                	if (c!=null){
                		if (c.get("F")!=null){
                			Map t=(Map)c.get("F");
                			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
                			}
                		}
                		if (c.get("L")!=null){
                			Map t=(Map)c.get("L");
                			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
                			}
                			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
                				masde49=masde49+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
                			}
                		}
                	}
                }
                	cell = row.createCell((short)4); 
                    cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.demasde49",idioma));
                    cell = row.createCell((short)6); 
                    cell.setCellStyle(styleDerechaNumeroFormateado(excel));
                    cell.setCellValue(masde49);
            } 
        }
        
        row = sheet.createRow((short)22); 
        cell = row.createCell((short)3); 
        cell.setCellValue("*"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.rescentrales",idioma)+"*");
	}
	
	private void crearcontenidoterritorio(HSSFWorkbook wb,int s,String idioma,Map m,String porcentaje) throws Q70GestorMensajesException{
		W83aUtilidadesExcel excel = new W83aUtilidadesExcel(wb);
		HSSFSheet sheet = wb.getSheetAt(s);
		HSSFRow row = sheet.createRow((short)23);
		HSSFCell cell = row.createCell((short)8);
		HSSFCell cell2 = row.createCell((short)9);
		
		sheet.addMergedRegion(new Region(23,(short)8,23,(short)9));
		cell.setCellStyle(bordeAbajo(excel));
		cell2.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.representantes",idioma));
    	row = sheet.createRow((short)24); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.central",idioma));
        cell.setCellStyle(bordeAbajo(excel));
        cell = row.createCell((short)2); 
        cell.setCellStyle(bordeAbajo(excel));
        cell = row.createCell((short)3); 
        cell.setCellStyle(bordeAbajo(excel));
        cell = row.createCell((short)4); 
        cell.setCellStyle(bordeAbajo(excel));
        cell = row.createCell((short)5); 
        cell.setCellStyle(bordeAbajo(excel));
        cell = row.createCell((short)6); 
        cell.setCellStyle(bordeAbajo(excel));
        cell = row.createCell((short)8); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.func",idioma));
        cell.setCellStyle(bordeAbajo(excel));
        cell = row.createCell((short)9); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.labo",idioma));
        cell.setCellStyle(bordeAbajo(excel));
        cell = row.createCell((short)10); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma));
        cell.setCellStyle(bordeAbajo(excel));
        cell = row.createCell((short)11); 
        cell.setCellValue("%");
        cell.setCellStyle(styleCentradoSubrayado(excel));
        
        String[] valores;
      
        Iterator it = m.entrySet().iterator();
        int numdelegadostotal=0;
        int cont=0;
        SortedMap map = new TreeMap(java.util.Collections.reverseOrder());
        int suma=0;
        while (it.hasNext()) {
        	suma=0;
        	cont++;
        	Map.Entry e = (Map.Entry)it.next();
        	Map c=(HashMap)e.getValue();
        	String a=(String)e.getKey();
        	
        	if (c!=null){
        		if (c.get("F")!=null){
		            numdelegadostotal=numdelegadostotal+Integer.parseInt((String)c.get("F"));
		            suma=suma+Integer.parseInt((String)c.get("F"));
        		}
        		if (c.get("L")!=null){
        			numdelegadostotal=numdelegadostotal+Integer.parseInt((String)c.get("L"));
        			suma=suma+Integer.parseInt((String)c.get("L"));
        		}
        	}
        	 map.put(W83aUtilidadesComunes.rellenarCeros(String.valueOf(suma))+"#"+String.valueOf(cont),a);
        }
        int contador=0;
        int numdelegadospubl=0;
        int numdelegadospriv=0;
       
        Double porcentajeFiltro=new Double(0.0);
        if(StringUtils.isNotEmpty(porcentaje)){
        	String porc=porcentaje.replace(',','.');
    		porcentajeFiltro = new Double(porc);
        }
        int delegados=0;
        int func=0;
        int labo=0;
        int tot=0;
        
        boolean otros=false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
	        Object key = iterator.next();
	        String valorClave=(String)map.get(key);
        	int numdelegados=0;
        	int numdelegadospu=0;
        	int numdelegadospr=0;
        	row = sheet.createRow((short)25+contador); // Creacin de la fila 1
            cell = row.createCell((short)1); 
            valores=valorClave.split("\\|");
            Map c=(HashMap)m.get(valorClave);
            if (c!=null){
        		if (c.get("L")!=null){
        			numdelegados=numdelegados+Integer.parseInt((String)c.get("L"));
		            numdelegadospriv=numdelegadospriv+numdelegados;
		            numdelegadospr=Integer.parseInt((String)c.get("L"));
        		}
        		if (c.get("F")!=null){
        		    numdelegados=Integer.parseInt((String)c.get("F"));
		            numdelegadospubl=numdelegadospubl+numdelegados;
		            numdelegadospu=Integer.parseInt((String)c.get("F"));
        		}
        		
        	}
          //debemos mirar  si el % supera el que hemos puesto, para ponerlo en otros
    		if(StringUtils.isNotEmpty(porcentaje)&&W83aUtilidades.porcentaje(numdelegadospr+numdelegadospu,numdelegadostotal)*100<porcentajeFiltro.floatValue()){
    			delegados=delegados+numdelegadospr+numdelegadospu;
    			if (c.get("F")!=null){
	            	func=func+Integer.parseInt((String)c.get("F"));
	            	}
	            	if (c.get("L")!=null){
	            	labo=labo+Integer.parseInt((String)c.get("L"));
	            	}
	            	tot=tot+numdelegadospu+numdelegadospr;
    			otros=true;
    		}
    		else{
            
	            if ("null".equals(valores[0])||valores[0]==null){
	            	cell.setCellValue("");
	            }
	            else{
	            	cell.setCellValue(valores[0]);
	            }
	            cell = row.createCell((short)2); 
	            if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
	            	if ("null".equals(valores[1])||valores[1]==null){
	            		cell.setCellValue("");
	            	}
	            	else{
	            		cell.setCellValue(valores[1]);
	            	}
	            }
	            else{
	            	if ("null".equals(valores[2])||valores[2]==null){
	            		cell.setCellValue("");
	            	}
	            	else{
	            		cell.setCellValue(valores[2]);
	            	}
	            	
	            }
	            cell2 = row.createCell((short)3);
	           
	            sheet.addMergedRegion(new Region((short)23+contador,(short)2,(short)23+contador,(short)6)); //NOPMD
	            inicializarCero(row, cell, 8);
	            inicializarCero(row, cell, 10);
	            inicializarCero(row, cell, 9);
	            
	            //Convenios
	        	
	        	if (c!=null){
	        		if (c.get("L")!=null){
	        			cell = row.createCell((short)9); 
			            cell.setCellValue(Integer.parseInt((String)c.get("L")));
			            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        		}
	        		if (c.get("F")!=null){
	        			cell = row.createCell((short)8); 
			            cell.setCellValue(Integer.parseInt((String)c.get("F")));
			            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
			        }
	        		
	        	}
	        	cell = row.createCell((short)10);
	        	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        	cell.setCellValue(numdelegadospr+numdelegadospu);
	        	
	        	cell = row.createCell((short)11);
	    		cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospr+numdelegadospu,numdelegadostotal));
	    		cell.setCellStyle(stylePorcentajesDcha(excel));
	        	
	    		contador=contador+1;
    		}
        }
        if(otros){
        	row = sheet.createRow((short)25+contador);
        	//metemos la linea de otros
    		cell = row.createCell((short)2);
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase());
    		
        	cell = row.createCell((short)8);
    		cell.setCellValue(func);
    		cell.setCellStyle(bordeAbajo(excel));
    		cell = row.createCell((short)9);
    		cell.setCellStyle(styleBordeArribaFormateado(excel));
    		cell.setCellValue(labo);
    		cell.setCellStyle(bordeAbajo(excel));
    		
    		cell = row.createCell((short)10);
    		cell.setCellStyle(styleBordeArribaFormateado(excel));
    		cell.setCellValue(tot);
    		cell.setCellStyle(bordeAbajo(excel));
    		cell.setCellStyle(styleBordeArribaFormateado(excel));
    		cell = row.createCell((short)11);
    		cell.setCellValue(W83aUtilidades.porcentaje(delegados,numdelegadostotal));
        	cell.setCellStyle(stylePorcentajesDcha(excel));
    		
    		
    		contador=contador+1;
        	
        }
        row = sheet.createRow((short)25+contador);
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",idioma).toUpperCase());
        cell.setCellStyle(bordeArriba(excel));
        cell = row.createCell((short)2); 
        cell.setCellStyle(bordeArriba(excel));
       
        cell = row.createCell((short)3); 
        cell.setCellStyle(bordeArriba(excel));
        
        cell = row.createCell((short)6); 
        cell.setCellStyle(bordeArriba(excel));
        
        cell = row.createCell((short)4); 
        cell.setCellStyle(bordeArriba(excel));
        
        cell = row.createCell((short)5); 
        cell.setCellStyle(bordeArriba(excel));        
        
        cell = row.createCell((short)9); 
        cell.setCellValue(numdelegadospriv);
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        
        cell = row.createCell((short)8); 
        cell.setCellValue(numdelegadospubl);
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        
        cell = row.createCell((short)10); 
        cell.setCellValue(numdelegadospubl+numdelegadospriv);
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
	}
	
	private void crearcontenidotodos(HSSFWorkbook wb,int s,String idioma,Map m,String porcentaje) throws Q70GestorMensajesException{
		Double porcentajeFiltro=new Double(0.0);
        if(StringUtils.isNotEmpty(porcentaje)){
        	String porc=porcentaje.replace(',','.');
    		porcentajeFiltro = new Double(porc);
        }
		W83aUtilidadesExcel excel = new W83aUtilidadesExcel(wb);
		HSSFSheet sheet = wb.getSheetAt(s);
		HSSFRow row = sheet.createRow((short)23); 
		HSSFCell cell = row.createCell((short)2); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.araba",idioma));
        cell = row.createCell((short)6); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.bizkaia",idioma));
        cell = row.createCell((short)10); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.gipuzkoa",idioma));
        
        cell = row.createCell((short)14); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.comautvasca",idioma));
        
        row = sheet.createRow((short)24); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase());
        cell = row.createCell((short)5); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase());
        cell = row.createCell((short)9); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase());
        cell = row.createCell((short)13); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase());
        
        row = sheet.createRow((short)25); 
        cell = row.createCell((short)0); 
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.central",idioma));
       
        cell = row.createCell((short)2);
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma));
        
        cell = row.createCell((short)1); 
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma));
                
        cell = row.createCell((short)3); 
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma));
        cell = row.createCell((short)4); 
        cell.setCellStyle(styleCentradoSubrayado(excel));
        cell.setCellValue("%");
        cell = row.createCell((short)5); 
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma));
        
        cell = row.createCell((short)7); 
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma));
               
        cell = row.createCell((short)6); 
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma));
       
        cell = row.createCell((short)8); 
        cell.setCellStyle(styleCentradoSubrayado(excel));
        cell.setCellValue("%");
       
        cell = row.createCell((short)9); 
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma));
        
        cell = row.createCell((short)10);
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma));
        
        cell = row.createCell((short)11);
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma));
        
        cell = row.createCell((short)12); 
        cell.setCellStyle(styleCentradoSubrayado(excel));
        cell.setCellValue("%");
        
        cell = row.createCell((short)13); 
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma));
        
        cell = row.createCell((short)14); 
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma));
        
        cell = row.createCell((short)15); 
        cell.setCellStyle(bordeAbajo(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma));
        
        cell = row.createCell((short)16); 
        cell.setCellStyle(styleCentradoSubrayado(excel));
        cell.setCellValue("%");
        
        Iterator it;
        Set ref = m.keySet();
		int ntpa=0;
		int ntpb=0;
		int ntpra=0;
		int ntprb=0;
		int ntpg=0;
		int ntprg=0;
		int nt=0;
		int cont=0;
		int suma=0;
        SortedMap map = new TreeMap(java.util.Collections.reverseOrder());
		for( it = ref.iterator(); it.hasNext();) {
			suma=0;
			cont++;
			String a=(String)it.next();
            Map c=(HashMap)m.get(a);
            if (c!=null){
            	if (c.get("F")!=null){
        			Map t=(Map)c.get("F");
        			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
//        				cell = row.createCell((short)1); 
//        				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA)));
//        				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        				ntpa=ntpa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
        				ntpb=ntpb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
        				ntpg=ntpg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        			}
        		}
        		if (c.get("L")!=null){
        			Map t=(Map)c.get("L");
        			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
        				ntpra=ntpra+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
        				ntprb=ntprb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
        				ntprg=ntprg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        				suma=suma+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        			}
        		}
        		
            }
            nt=ntpa+ntpb+ntpg+ntpra+ntprb+ntprg;
            map.put(W83aUtilidadesComunes.rellenarCeros(String.valueOf(suma))+"#"+String.valueOf(cont),a);
        }
		ref = m.keySet();
		String[] valores;
		int numdelegadospublal=0;
		int numdelegadospublbi=0;
		int numdelegadospublgi=0;
		int numdelegadosprival=0;
		int numdelegadosprivbi=0;
		int numdelegadosprivgi=0;
		int numdelegadostotpublal=0;
		int numdelegadostotpublbi=0;
		int numdelegadostotpublgi=0;
		int numdelegadostotprival=0;
		int numdelegadostotprivbi=0;
		int numdelegadostotprivgi=0;
		int numdelegadospublalpor=0;
		int numdelegadospublbipor=0;
		int numdelegadospublgipor=0;
		int numdelegadosprivalpor=0;
		int numdelegadosprivbipor=0;
		int numdelegadosprivgipor=0;
		int numdelegadostotpublalpor=0;
		int numdelegadostotpublbipor=0;
		int numdelegadostotpublgipor=0;
		int numdelegadostotprivalpor=0;
		int numdelegadostotprivbipor=0;
		int numdelegadostotprivgipor=0;
		int contador=0;
		boolean otros=false;
		Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
	        Object key = iterator.next();
	        String valorClave=(String)map.get(key);
        	numdelegadospublal=0;
    		numdelegadospublbi=0;
    		numdelegadospublgi=0;
    		numdelegadosprival=0;
    		numdelegadosprivbi=0;
    		numdelegadosprivgi=0;
    		
        	row = sheet.createRow((short)26+contador); // Creacin de la fila 1
            cell = row.createCell((short)0); 
            valores=valorClave.split("\\|");
            int nuestroalava=0;
            int nuestrovizcaya=0;
            int nuestroguipuzcoa=0;
            //sumamos los valores para calcular el %
            Map c=(HashMap)m.get(valorClave);
            if (c!=null){
            	if (c.get("F")!=null){
        			Map t=(Map)c.get("F");
        			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
        				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
        				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
        				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        			}
        		}
        		if (c.get("L")!=null){
        			Map t=(Map)c.get("L");
        			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
        				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
        				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
        			}
        			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
        				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
        			}
        		}
            }
            //comprobamos que el % de nuestros valores supere o no el porcentaje
            if(StringUtils.isNotEmpty(porcentaje)&&W83aUtilidades.porcentaje(nuestroalava+nuestrovizcaya+nuestroguipuzcoa,nt)*100<porcentajeFiltro.floatValue()){
            	if (c!=null){
                	if (c.get("F")!=null){
            			Map t=(Map)c.get("F");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				numdelegadospublal=numdelegadospublal+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            				numdelegadospublalpor=numdelegadospublalpor+numdelegadospublal;
            				numdelegadostotpublal=numdelegadostotpublal+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            				numdelegadostotpublalpor=numdelegadostotpublalpor+numdelegadostotpublal;
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				numdelegadospublbi=numdelegadospublbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            				numdelegadospublbipor=numdelegadospublbipor+numdelegadospublbi;
            				numdelegadostotpublbi=numdelegadostotpublbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            				numdelegadostotpublbipor=numdelegadostotpublbipor+numdelegadostotpublbi;
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				numdelegadospublgi=numdelegadospublgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            				numdelegadospublgipor=numdelegadospublgipor+numdelegadospublgi;
            				numdelegadostotpublgi=numdelegadostotpublgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            				numdelegadostotpublgipor=numdelegadostotpublgipor+numdelegadostotpublgi;
            			}
            		}
            		if (c.get("L")!=null){
            			Map t=(Map)c.get("L");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				numdelegadosprival=numdelegadosprival+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            				numdelegadosprivalpor=numdelegadosprivalpor+numdelegadosprival;
            				numdelegadostotprival=numdelegadostotprival+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            				numdelegadostotprivalpor=numdelegadostotprivalpor+numdelegadostotprival;
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				numdelegadosprivbi=numdelegadosprivbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            				numdelegadosprivbipor=numdelegadosprivbipor+numdelegadosprivbi;
            				numdelegadostotprivbi=numdelegadostotprivbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            				numdelegadostotprivbipor=numdelegadostotprivbipor+numdelegadostotprivbi;
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				numdelegadosprivgi=numdelegadosprivgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            				numdelegadosprivgipor=numdelegadosprivgipor+numdelegadosprivgi;
            				numdelegadostotprivgi=numdelegadostotprivgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            				numdelegadostotprivgipor=numdelegadostotprivgipor+numdelegadostotprivgi;
            			}
            		}
                }
            	otros=true;
            }
            else{
            //cuando nuestros valores superan el porcentaje
	            if ("null".equals(valores[0])||valores[0]==null){
	            	cell.setCellValue("");
	            }
	            else{
	            	cell.setCellValue(valores[0]);
	            }
	            inicializarCero(row, cell, 1);
	            inicializarCero(row, cell, 2);
	            inicializarCero(row, cell, 5);
	            inicializarCero(row, cell, 6);
	            inicializarCero(row, cell, 9);
	            inicializarCero(row, cell, 10);
	          
	            if (c!=null){
	            	if (c.get("F")!=null){
	        			Map t=(Map)c.get("F");
	        			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
	        				cell = row.createCell((short)1); 
	        				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA)));
	        				numdelegadospublal=numdelegadospublal+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	        				numdelegadostotpublal=numdelegadostotpublal+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	        			}
	        			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
	        				cell = row.createCell((short)9); 
	        				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)));
	        				numdelegadospublgi=numdelegadospublgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	        				numdelegadostotpublgi=numdelegadostotpublgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	        			}
	        			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
	        				cell = row.createCell((short)5); 
	        				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)));
	        				numdelegadospublbi=numdelegadospublbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	        				numdelegadostotpublbi=numdelegadostotpublbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	        			}
	        		}
	        		if (c.get("L")!=null){
	        			Map t=(Map)c.get("L");
	        			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
	        				cell = row.createCell((short)2); 
	        				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA)));
	        				numdelegadosprival=numdelegadosprival+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	        				numdelegadostotprival=numdelegadostotprival+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	        			}
	        			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
	        				cell = row.createCell((short)10); 
	        				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)));
	        				numdelegadosprivgi=numdelegadosprivgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	        				numdelegadostotprivgi=numdelegadostotprivgi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	        			}
	        			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
	        				cell = row.createCell((short)6);
	        				cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	        				cell.setCellValue(Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)));
	        				numdelegadosprivbi=numdelegadosprivbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	        				numdelegadostotprivbi=numdelegadostotprivbi+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	        			}
	        		}
	        		cell = row.createCell((short)3);
	        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	    			cell.setCellValue(numdelegadospublal+numdelegadosprival);
	    			cell = row.createCell((short)4);
	    			cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublal+numdelegadosprival,ntpa+ntpra));
	    			cell.setCellStyle(stylePorcentajesDcha(excel));
	        		cell = row.createCell((short)11);
	        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	    			cell.setCellValue(numdelegadospublgi+numdelegadosprivgi);
	    			cell = row.createCell((short)12);
	    			cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublgi+numdelegadosprivgi,ntpg+ntprg));
	    			cell.setCellStyle(stylePorcentajesDcha(excel));
	    			cell = row.createCell((short)7);
	    			cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	    			cell.setCellValue(numdelegadospublbi+numdelegadosprivbi);
	    			cell = row.createCell((short)8);
	    			cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublbi+numdelegadosprivbi,ntpb+ntprb));
	    			cell.setCellStyle(stylePorcentajesDcha(excel));
	            }
	            cell = row.createCell((short)13); 
	            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            cell.setCellValue(numdelegadospublal+numdelegadospublbi+numdelegadospublgi);
	            cell = row.createCell((short)14); 
	            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            cell.setCellValue(numdelegadosprival+numdelegadosprivbi+numdelegadosprivgi);
	            cell = row.createCell((short)15); 
	            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
	            cell.setCellValue(numdelegadospublal+numdelegadospublbi+numdelegadospublgi+numdelegadosprival+numdelegadosprivbi+numdelegadosprivgi);
	            cell = row.createCell((short)16); 
	            cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublal+numdelegadospublbi+numdelegadospublgi+numdelegadosprival+numdelegadosprivbi+numdelegadosprivgi,nt));
	            cell.setCellStyle(stylePorcentajesDcha(excel));
	            contador=contador+1;
			}
			
        }
		if(otros){
			row = sheet.createRow((short)26+contador);
			cell = row.createCell((short)0); 
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase());
	       
	        cell = row.createCell((short)1); 
	        cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	cell.setCellValue(numdelegadospublalpor);
        	cell = row.createCell((short)5); 
        	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	cell.setCellValue(numdelegadospublbipor);
        	cell = row.createCell((short)9); 
        	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	cell.setCellValue(numdelegadospublgipor);
        	cell = row.createCell((short)2); 
        	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	cell.setCellValue(numdelegadosprivalpor);
        	cell = row.createCell((short)6); 
        	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	cell.setCellValue(numdelegadosprivbipor);
        	cell = row.createCell((short)10);
        	cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	cell.setCellValue(numdelegadosprivgipor);
        	
        	cell = row.createCell((short)3);
    		cell.setCellValue(numdelegadospublalpor+numdelegadosprivalpor);
    		cell = row.createCell((short)4);
    		cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublalpor+numdelegadosprivalpor,ntpa+ntpra));
			cell.setCellStyle(stylePorcentajesDcha(excel));
    		cell = row.createCell((short)11);
    		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
			cell.setCellValue(numdelegadospublgipor+numdelegadosprivgipor);
			cell = row.createCell((short)12);
			cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublgipor+numdelegadosprivgipor,ntpg+ntprg));
			cell.setCellStyle(stylePorcentajesDcha(excel));
			cell = row.createCell((short)7);
			cell.setCellStyle(styleDerechaNumeroFormateado(excel));
			cell.setCellValue(numdelegadospublbipor+numdelegadosprivbipor);
			cell = row.createCell((short)8);
			cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublbipor+numdelegadosprivbipor,ntpb+ntprb));
			cell.setCellStyle(stylePorcentajesDcha(excel));
           
			
			
			cell = row.createCell((short)13); 
			cell.setCellStyle(styleDerechaNumeroFormateado(excel));
            cell.setCellValue(numdelegadospublalpor+numdelegadospublbipor+numdelegadospublgipor);
            cell = row.createCell((short)14); 
            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
            cell.setCellValue(numdelegadosprivalpor+numdelegadosprivbipor+numdelegadosprivgipor);
            cell = row.createCell((short)15); 
            cell.setCellStyle(styleDerechaNumeroFormateado(excel));
            cell.setCellValue(numdelegadospublalpor+numdelegadospublbipor+numdelegadospublgipor+numdelegadosprivalpor+numdelegadosprivbipor+numdelegadosprivgipor);
            cell = row.createCell((short)16); 
            cell.setCellValue(W83aUtilidades.porcentaje(numdelegadospublalpor+numdelegadospublbipor+numdelegadospublgipor+numdelegadosprivalpor+numdelegadosprivbipor+numdelegadosprivgipor,nt));
            cell.setCellStyle(stylePorcentajesDcha(excel));
            contador=contador+1;
		}
		//total
		row = sheet.createRow((short)26+contador);
        cell = row.createCell((short)0); 
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",idioma).toUpperCase());
        cell = row.createCell((short)1); 
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotpublal);
        cell = row.createCell((short)2); 
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotprival);
        cell = row.createCell((short)3); 
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotpublal+numdelegadostotprival);
        cell = row.createCell((short)9);
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotpublgi);
        cell = row.createCell((short)10); 
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotprivgi);
        cell = row.createCell((short)11);
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotpublgi+numdelegadostotprivgi);
        cell = row.createCell((short)5); 
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotpublbi);
        cell = row.createCell((short)6);
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotprivbi);
        cell = row.createCell((short)7); 
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotpublbi+numdelegadostotprivbi);
        cell = row.createCell((short)13); 
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotpublal+numdelegadostotpublgi+numdelegadostotpublbi);
        cell = row.createCell((short)14); 
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotprival+numdelegadostotprivbi+numdelegadostotprivgi);
        cell = row.createCell((short)15); 
        cell.setCellStyle(bordeArriba(excel));
        cell.setCellStyle(styleBordeArribaFormateado(excel));
        cell.setCellValue(numdelegadostotpublal+numdelegadostotpublgi+numdelegadostotpublbi+numdelegadostotprival+numdelegadostotprivbi+numdelegadostotprivgi);
	}
	
	private HSSFCellStyle bordeAbajo(W83aUtilidadesExcel excel){
		return excel.styleBordeAbajo;			
		
	}
	private HSSFCellStyle bordeArriba(W83aUtilidadesExcel excel){
		return excel.styleBordeArriba;			
		
	}
	private HSSFCellStyle stylePorcentajesDcha(W83aUtilidadesExcel excel){
		return excel.stylePorcentajesDcha;			
		
	}

	private HSSFCellStyle styleCentradoSubrayado(W83aUtilidadesExcel excel){
		return excel.styleCentradoSubrayado;			
		
	}
	
	private HSSFCellStyle styleDerechaNumeroFormateado(W83aUtilidadesExcel excel){
		return excel.styleDerechaNumeroFormateado;	
	}
	
	private HSSFCellStyle styleBordeArribaFormateado(W83aUtilidadesExcel excel){
		return excel.styleBordeArribaFormateado;	
	}
}

